<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Login controller will have authentication realted functions
 */
class Dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
       // use_ssl();
	   
	   $this->common->check_access_rights('Dashboard'); 
	   $this->load->model('Dashboard_model');
    }

   
    public function index() {
		$data['role'] = $this->session->userdata('role');
		$user_id = '';
		if($data['role'] != '1') {
			$user_id = $this->session->userdata('user_id');;
		}
		
        $data['csv_list'] = $this->Dashboard_model->get_csv_list($user_id);
        $this->template->load('template/private','csv-listing-view', $data); 
    }
	
	
	public function get_csv_list() {
        $list_data = array('status' => 'error', 'data' => '');
        $post = $this->input->post(NULL,TRUE);
		$role = $this->session->userdata('role');		
		
		$start_date = isset($post['start_date']) && $post['start_date'] != '' ? date('Y-m-d', strtotime($post['start_date'])) : '';
		$end_date = isset($post['end_date']) && $post['end_date'] != '' ? date('Y-m-d', strtotime($post['end_date'])) : '';
		$domain = isset($post['domain']) && !empty($post['domain']) ? $post['domain'] : '';
		$device = isset($post['device']) && !empty($post['device']) ? $post['device'] : '';
		$user_id = isset($post['user']) && !empty($post['user']) ? $post['user'] : '';
		if($user_id == '') {
			if($role != '1') {
				$user_id = $this->session->userdata('user_id');;
			}
		}
		$filter_by = isset($post['filter_by']) && !empty($post['filter_by']) ? $post['filter_by'] : '';
		
        $list = $this->Dashboard_model->get_csv_list($user_id, $device, $domain, $start_date, $end_date, $filter_by);
        if (!empty($list)) {
            foreach ($list as $csv) {
				if($role == '1') {
                $data[] = array(
                    $csv['date'],
                    $csv['brand_name'],                   
                    $csv['domain'],                   
                    $csv['device_type'],                   
                    $csv['requests'],                   
                    $csv['impressions'],                   
                    $csv['cpm'],                   
                    round($csv['estimated_revenue'],2),                   
                    $csv['first_name']                  
                );
				}
				if($role == '2') {
                $data[] = array(
                    $csv['date'],
                    $csv['domain'],                   
                    $csv['device_type'],                   
                    $csv['impressions'],                   
                    $csv['cpm'],                   
                    round($csv['estimated_revenue'],2),                 
                );
				}
            }
            $list_data = array('status' => 'done', 'data' => $data);
        }
        
        echo json_encode($list_data);
    }
	
	
	
}
