<?php

if (!defined('BASEPATH'))
   exit('No direct script access allowed');

class Users extends CI_Controller {

   public function __construct() {
      parent::__construct();
     // use_ssl();
	 $this->common->check_access_rights('Users'); 
        $this->load->model('User_model');
   }
   
 
       /**
     * Objective is to provide view for add user manage
     * @param init  
     * @return view load list_available_users
     */
    public function index() {    	
          $this->template->load('template/private','list_available_users', '');
    }
     
    /** Objective is to get users list
     * @return users list array
     */
    public function get_users_list() {
        $user_list_data = array('status' => 'error', 'data' => '');
        $post = $this->input->post(NULL,TRUE);
      
        $user_list = $this->User_model->get_users_list();
        if (!empty($user_list)) {
            foreach ($user_list as $user_id => $users) {
                $actions = '<div class="btn-group">
                            <a href="' . base_url() . 'Users/add_edit_users/' . $user_id . '" rel="50%" data-toggle="tooltip" data-placement="top" title="Edit User" class="toolTips btn btn-default"><span class="fa fa-pencil"></span></a>
                            <a onclick="deleteUser(' . $user_id . ','.$users['role_id'].')" href="javascript:void(0);" rel="' . $user_id . '" data-toggle="tooltip" data-placement="top" title="Delete User" class="toolTips btn  btn-default"><span class="fa fa-trash"></span></a>
                            </div>';
                            
                $data[] = array(
                    $users['user_id'],
                    ucwords($users['name']),
                    $users['email'],
                    $users['role_name'],
                    $users['status_label'],
                    $actions
                );
            }
            $user_list_data = array('status' => 'done', 'data' => $data);
        }
        
        echo json_encode($user_list_data);
    }
     /**
     * Objective is to provide view from where subject id can add edit subject
     * @param init $subject_id id of subject
     * @return view load add_edit_subject_view
     */
    public function add_edit_users($user_id = '') {
    	
        $user_data = array();
        if ($user_id != '0') {
            $user_data = $this->User_model->get_users_list($user_id);
        }else{
             $user_data = $this->User_model->get_users_list();
        }
        $data['user_role'] = $this->session->userdata('role');
        $data['user_id'] = $user_id;
        $data['user_list'] = $user_data;
        $this->template->load('template/private','add_edit_users_view', $data);
    }
    
       /**
     * Objective is to provide save academic_year 
     * @param null
     *  @return academic_year responce 
     */
    public function save_user() {

        $post = $this->input->post(NULL, TRUE);
       
        $add_response = array(
            'is_added' => FALSE
        );
        $responce = array('status' => 'error','message' => '');
        $user_data = array();
      
        $user_data['first_name'] = $post['name'];
        $user_data['email'] = $post['username'];
        if($post['password'] != ''){
        $user_data['password'] = md5($post['password']);
        }
         $user_data['role_id'] = $post['role'];
          $user_data['status'] = $post['status'];
         
        if ($post['user_id'] == '0') {
           $user_data['created_by'] = $this->session->userdata('user_id');
            $add_response = $this->User_model->add_user($user_data);
			$user_id = $add_response['user_id'];
            
        } else {
            $add_response = $this->User_model->update_user($user_data, $post['user_id']);
			$user_id = $post['user_id'];
        }
        
        if ($add_response['is_added']) {
            $responce = array('status' => 'done','message' => '<div class="alert alert-success">User saved successfully.</div>');
              echo json_encode($responce);
        } else {
            $responce = array('status' => 'error','message' => '<div class="alert alert-danger">An error has occurred while saving User!</div>');
              echo json_encode($responce);
        }
    }
	
     public function delete_user($user_id) {
        $post = $this->input->post(NULL, TRUE);
         $add_response = $this->User_model->delete_user($user_id);

        if ($add_response) {
            $responce = array('status' => 'done','message' => '<div class="alert alert-success">User Deleted.</div>');
              echo json_encode($responce);
        } else {
            $responce = array('status' => 'error','message' => '<div class="alert alert-danger">An error has occurred while deleting User !</div>');
              echo json_encode($responce);
        }
    }
    
    
    /*public function is_user_engaged($user_id, $role_id) {
         $user_data = array();
         $is_user_engaged = $this->User_model->is_user_engaged($user_id, $role_id);

        if ($is_user_engaged) {
            $responce = array('status' => 'true');
              echo json_encode($responce);
        } else {
            $responce = array('status' => 'false');
              echo json_encode($responce);
        }
    }*/
    
    
		
}
