<?php

Class User_model extends CI_Model {

   function __construct() {
      // Call the Model constructor
      parent::__construct();
   }

   /**
    * Objective is to add user
    * @param array $user_data having user related details
    * @return array having status and user_id
    */
   function add_user($user_data) {
      //die(print_r($user_data));
      $is_added = FALSE;
      $user_id = 0;
      $this->db->set('created_on', 'NOW()', FALSE);
      $email = $user_data['email'];
      $result = $this->db->select('id')->where('email', $email)->get('user_master');
      if ($result->num_rows() <= 0) {
         $this->db->insert('user_master', $user_data);
         $user_id = $this->db->insert_id();
         if ($this->db->affected_rows() > 0)
            $is_added = TRUE;
      }
      $response = array('is_added' => $is_added, 'user_id' => $user_id);
      return $response;
   }

   /**
    * Objective is to delete user from database
    * @param int $user_id user id
    * @return boolean true on success
    */
   function delete_user($user_id) {
      $sql_delete_user = "delete from user_master
                where id='$user_id' ";
      $query_delete_user = $this->db->query($sql_delete_user);
      if ($this->db->affected_rows() > 0) {
      	 return TRUE;
      } else {
         return FALSE;
      }
   }

   /**
    * Objective is to get user list 
    * @param string $user_id id of user
    * @param string $role_id if wnats list of particular roles
    * @param string $username username
    * @return array list of users
    */
   function get_users_list($user_id = '', $role_id = '', $username = '') {
	  $logged_in_user = $this->session->userdata('user_id');
	  $logged_in_role = $this->session->userdata('role');
      $user_list = array();
      $sql_user_list = "select id,first_name,last_name,email,password,role_id,status
         from user_master um where id <> '$logged_in_user'";
      if ($user_id != '') {
         $sql_user_list .= " and id=$user_id ";
      }
      if ($role_id != '') {
         $sql_user_list .= " and role_id=$role_id";
      }
      if ($username != '') {
         $sql_user_list .= " and email='$username'";
      }
     
      $sql_user_list.=' order by role_id,email ';
      $query_user_list = $this->db->query($sql_user_list);
      if ($query_user_list->num_rows() > 0) {
         foreach ($query_user_list->result() as $row) {
            $status_label = '';
            if ($row->status == '0') {
               $status_label = 'Inactive';
			}else if ($row->status == '1') {
               $status_label = 'Active';
			}

            if($row->role_id == '1') {
               $role_name = 'Admin';
            }else if($row->role_id == '2') {
               $role_name = 'Publisher';
            }

            $user_list[$row->id] = array('user_id' => $row->id,
               'name' => $row->first_name .' '. $row->last_name,
               'email' => $row->email,
               'password' => $row->password,
               'role_id' => $row->role_id,
               'role_name' => $role_name,
               'status' => $row->status,
               'status_label' => $status_label);
         }
      }
      return $user_list;
   }

   
   /**
    * Objective is to update user data
    * @param array $user_data having user related details
    * @param string $user_id id of user
    * @return boolean true on success
    */
   function update_user($user_data, $user_id='', $email='') {
	  if($user_id != '') {
		$this->db->where('id', $user_id);
	  }
	  if($email != '') {
		$this->db->where('email', $email);
	  }
      $this->db->update('user_master', $user_data);
      if ($this->db->affected_rows() >= 0) {
         $is_added = TRUE;
	  }else {
         $is_added = FALSE;
	  }
	  $response = array('is_added' => $is_added);
	  
	  return $response;
   }

 

   /**
    * Objective is to validate user
    * @param string $username username
    * @param string $password password
    * @return array having user details
    */
   function validate_user($username, $password = '') {
      $user_details = array('is_valid' => FALSE,
         'user_id' => '',
         'name' => '',
         'username' => '',
         'role_id' => '',
         'status' => '',
         'last_login' => '',
         );
      $sql_valid_user = "select id,first_name,last_name,email,role_id,status,last_login            
            from user_master um
            where (email='$username' or username='$username') and status = '1' ";
      if ($password != '') {
         $sql_valid_user.=" and password='$password' ";
      }
      $query_validate_user = $this->db->query($sql_valid_user);
      if ($query_validate_user->num_rows() > 0) {
         $row = $query_validate_user->result();
         
         $user_details = array('is_valid' => TRUE,
            'user_id' => $row[0]->id,
            'name' => $row[0]->first_name .' '. $row[0]->last_name,
            'email' => $row[0]->email,
            'role_id' => $row[0]->role_id,         
            'status' => $row[0]->status,
            'last_login' => $row[0]->last_login
         );
      }
      return $user_details;
   }

   
   
   /**
    * Objective is to get user list 
    * @param string $user_id id of user
    * @param string $role_id if wnats list of particular roles
    * @param string $username username
    * @return array list of users
    */
   function get_user_data($user_id = '', $email = '') {
      $sql_user_list = "select id,first_name,last_name,email,password,role_id,status
         from user_master ";
      if ($user_id != '') {
         $sql_user_list .= " where id=$user_id ";
      }
	  if ($email != '') {
         $sql_user_list .= " where email='$email' ";
      }
      
	  $result = array();
      $query_user_list = $this->db->query($sql_user_list);
      if ($query_user_list->num_rows() > 0) {
        $result = $query_user_list->row_array();
      }
      return $result;
   }
   
   

}
