<?php 
$domain_list = array();
$device_list = array();
$user_list = array();

foreach($csv_list as $csv) {
	$domain_list[$csv['domain']] = $csv['domain'];
	$device_list[$csv['device_type']] = $csv['device_type'];
	$user_list[$csv['user_id']] = $csv['first_name'];
}
?>
<style>
.numericCol{
  text-align:right;
}
</style>
<section class="content-header">
	<h1>Dashboard</h1>  
	<ol class="breadcrumb">
	  <li class="active">Home</li>
	</ol>
</section>

<section class="content">
	<div class="row">
		<div class="col-xs-12">
		<div id="ajax_response" style="display: none;"></div>
			<div class="box box-primary">
				<div class="box-body">
					<div class="col-xs-12">
						<div class="form-group col-xs-12 col-sm-4">
							<label class="control-label">From/To Date: </label>  
							<div class="input-group">                  
							  <input type="text" name="start_date" id="start_date" class="form-control" placeholder="From/To Date" value="<?php echo date('Y-m-01')?> to <?php echo date('Y-m-d');?>">
							  <div class="input-group-addon">
								<i class="fa fa-calendar"></i>
							  </div>
							</div>							
						</div>
						<div class="form-group col-xs-12 col-sm-4">
							<label class="control-label">Domain: </label> 
								<select class="form-control select2" multiple="multiple" id="domain" data-placeholder="Select Domain">
									<?php foreach($domain_list as $domain) { ?>
										<option value="<?php echo $domain;?>"><?php echo $domain;?></option>
									<?php } ?>
								</select>
						</div>
						<div class="form-group col-xs-12 col-sm-4">
							<label class="control-label">Device: </label> 
								<select class="form-control select2" multiple="multiple" id="device" data-placeholder="Select Device">
									<?php foreach($device_list as $device) { ?>
										<option value="<?php echo $device;?>"><?php echo $device;?></option>
									<?php } ?>
								</select>
						</div>
					</div>
				
					<div class="col-xs-12">
					<?php if($role == '1') { ?>
						<div class="form-group col-xs-12 col-sm-4">
							<label class="control-label">User: </label> 
							<select class="form-control select2" multiple="multiple" id="user" data-placeholder="Select User">
								<?php foreach($user_list as $user_id => $user) { ?>
									<option value="<?php echo $user_id;?>"><?php echo $user;?></option>
								<?php } ?>
							</select>
						</div>
					<?php } ?>	
					<?php if($role == '2') { ?>
					<div class="form-group col-xs-12 col-sm-4">
						<label class="control-label" style="margin-right:5px;">View By: </label> 
								
						<!--<label style="margin-right:5px;">
							 <input type="radio" name="filter_by" class="minimal" id="filter_by" value="date"/> Date
						</label>-->
						<label class="control-label" for="filter_by">Date </label>
						<label class="switch">
							<input type="checkbox" name="filter_by" >
							<span class="slider round"></span>
						</label>
					</div>
					<?php } ?>
					</div>
					
				</div>
				
				<div class="box-footer">
						<input type="button" name="btnFilter" id="btnFilter" value="Filter" class="btn btn-primary" />	
						<?php if($role == '1') { ?>
						<input type="button" name="btnDelete" id="btnDelete" value="Delete Records" class="btn btn-danger pull-right" />
						<?php } ?>						
				</div>
			</div>
			
			<div class="box box-success">
				<div class="box-body table-responsive">
					<table id="csv_list" class="nowrap table table-striped table-bordered table-condensed" cellspacing="0" width="100%">
						<thead>
						<?php if($role == '1') { ?>
							<tr>
								<th>Date</th>
								<th>Brand Name</th>
								<th>Domain</th>
								<th>Device Type</th>
								 <th>Requests</th>
								<th>Impressions</th>
								<th>CPM</th>
								<th>Estimated Revenue</th>
								<th>User</th>
							</tr>
							</thead>
						<tbody>
						</tbody>
						<tfoot>
            <tr>
                <th colspan="7" style="text-align:right">Total:</th>
                <th></th>
				<th></th>
            </tr>
        </tfoot>
						<?php } ?>
						<?php if($role == '2') { ?>
							<tr>
								<th>Date</th>
								<th>Domain</th>
								<th>Device Type</th>
								<th>Impressions</th>
								<th>CPM</th>
								<th>Estimated Revenue</th>
							</tr>
							</thead>
						<tbody>
						</tbody>
						<tfoot>
							<tr>
								<th colspan="5" style="text-align:right">Total:</th>
								<th></th>
							</tr>
						</tfoot>
						<?php } ?>
						
					</table>
				</div>
			</div>
		</div>
	</div>
</section>

<script>


    var oTable;
	$("select").select2();
	$('#start_date').dateRangePicker();		
	$('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
      checkboxClass: 'icheckbox_minimal-blue',
      radioClass: 'iradio_minimal-blue'
    });
	
    $(document).ready(function () {
		
      <?php if($role == '1') { ?>
        oTable = $('#csv_list').dataTable({
           "aoColumns": [
               null,
               null,
               null,
               null,
               {"sClass": "numericCol"},
               {"sClass": "numericCol"},
               {"sClass": "numericCol"},
               {"sClass": "numericCol"},
               null,
           ],
		   "order": [[ 0, "asc" ]],
		   "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // Remove the formatting to get integer data for summation
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,-]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column( 7 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column( 7, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column( 7 ).footer() ).html(
                'Total : '+pageTotal.toFixed(2) +'<br/>Grand Total : '+ total.toFixed(2)
            );
        },
		   "dom": 'Blfrtip',
			"buttons": [            
				{
                extend: 'excelHtml5',
                exportOptions: {
                    columns: ':visible'
                }
				}          
			]
        });
		<?php } ?>
		
		<?php if($role == '2') { ?>
			oTable = $('#csv_list').dataTable({
           "aoColumns": [
               null,
               null,
               null,
               {"sClass": "numericCol"},
               {"sClass": "numericCol"},
               {"sClass": "numericCol"},
           ],
		   "order": [[ 0, "asc" ]],
		   "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // Remove the formatting to get integer data for summation
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,-]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column( 5, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column( 5 ).footer() ).html(
                'Total : '+pageTotal.toFixed(2) +'<br/>Grand Total : '+ total.toFixed(2)
            );
        },
		   "dom": 'Blfrtip',
			"buttons": [            
				{
                extend: 'excelHtml5',
                exportOptions: {
                    columns: ':visible'
                }
				}          
			]
        });
		<?php } ?>
		
		 
        load_csv();

    });

    function load_csv() {
        var date_range = $('#start_date').val().split(' to ');
		var start_date = date_range[0];
		var end_date = date_range[1];
		var domain = $('#domain').val();
		var device = $('#device').val();
		var user = $('#user').val();
		var filter = $("input[name='filter_by']:checked").val();
		var filter_by = '';
		if(filter == 'on') {
			filter_by = 'date';
		}
		
        $.ajax({
            type: 'POST',
            url: '<?php echo $base_url; ?>/Dashboard/get_csv_list',
            dataType: 'json',
			data : {
				'start_date':start_date,
				'end_date':end_date,
				'domain':domain,
				'device':device,
				'user':user,
				'filter_by':filter_by
			},
            beforeSend: function () {
                //$.loading_dialog({text: "Please wait..."});
            },
            success: function (ajax_response) {
                console.log(ajax_response);
                //$.close_loading_dialog();
                oTable.fnClearTable();
                oTable.fnFilter('');
                if (ajax_response.status == 'done') {
                    var trs = ajax_response.data;
                    var tr_cnt = trs.length;
                    if (tr_cnt > 0) {
                        oTable.dataTable().fnAddData(trs);
                        oTable.dataTable().fnDraw();
                    }
					
					if(filter_by == 'date') {
						oTable.fnSetColumnVis( 2, false );
						oTable.fnSetColumnVis( 4, false );
					}else {
						oTable.fnSetColumnVis( 2, true );
						oTable.fnSetColumnVis( 4, true );
					}
                } else if (ajax_response.status == 'error') {
                    $('#ajax_session_exipred').modal();
                }
            }, error: function () {
                //$.close_loading_dialog();
                $.alert_dialog({
                    title: 'Alert',
                    text: "An error has occurred while loading listing",
                    OkButton: "OK"
                });
            }
        })
    }
	
	
	$(document).on('click', '#btnFilter', function () {
		load_csv();
	});
	
	$(document).on('click', '#btnDelete', function () {
		var date_range = $('#start_date').val().split(' to ');
		var start_date = date_range[0];
		var end_date = date_range[1];
		var domain = $('#domain').val();
		var device = $('#device').val();
		var user = $('#user').val();
		
		if (confirm('Are you sure you want to permanently remove the records ?')) {
		
        $.ajax({
            type: 'POST',
            url: '<?php echo $base_url; ?>/Csv_upload/delete_csv',
            dataType: 'json',
			data : {
				'start_date':start_date,
				'end_date':end_date,
				'domain':domain,
				'device':device,
				'user':user,
			},
            beforeSend: function () {
                //$.loading_dialog({text: "Please wait..."});
            },
            success: function (ajax_response) {
                console.log(ajax_response);
                //$.close_loading_dialog();
               
                if (ajax_response.status == 'done') {
					$('#ajax_response').show();
                        $('#ajax_response').html(ajax_response.message);
                        $("#ajax_response").fadeTo(2000, 500).slideUp(500, function () {
                        });
						$('#start_date').val('');
						$('#domain').select2('val','');
						$('#device').select2('val','');
						$('#user').select2('val','');
						
						setTimeout(function(){ 
							load_csv();
						}, 500);
                } else if (ajax_response.status == 'error') {
                    $('#ajax_session_exipred').modal();
                }
            }, error: function () {
                //$.close_loading_dialog();
                $.alert_dialog({
                    title: 'Alert',
                    text: "An error has occurred while Deleting Data",
                    OkButton: "OK"
                });
            }
        });
		}
	});
    
          
   
</script>


