<?php
$base_url = $this->config->item('base_url');
$include_url = $this->config->item('include_url');
$modal_title = 'Edit Profile';

?>
<section class="content-header">
	<h1><?php echo $modal_title; ?></h1>
</section>

<section class="content">
	<div class="row">
		<div class="col-xs-12">
			<div class="box box-primary">
				<div class="col-xs-12" id="ajax_response_1" style="display: none;"><?php echo $this->session->flashdata('message'); ?></div>
				<div class="col-xs-12" id="ajax_response" style="display: none;"></div>
				<form name="frmAddUser" id="frmAddUser" role="form">
					<div class="box-header with-border">
						<h3 class="box-title"><?php echo $modal_title; ?></h3>
					</div>
					<div class="box-body">
						<input type="hidden" name="user_id" id="user_id" value="<?php echo $user_id; ?>"/>
						<div class="form-group col-xs-4">
							<label class="control-label" for="name">Name <span class="required">*</span> :</label>
							<input type="text" name="name" id="name" value="<?php echo $user[0]['first_name']; ?>" placeholder="Name" class="form-control" maxlength="100"/>
						</div>
						<div class="form-group col-xs-4">
							<label class="control-label" for="username">Username :</label>
							<input readonly type="text" name="username" id="username" value="<?php echo $user[0]['username']; ?>" placeholder="Username" class="form-control" maxlength="100"/>
						</div>
						<div class="form-group col-xs-4">
							<label class="control-label" for="email">Email :</label>
							<input type="text" name="email" id="email" value="<?php echo $user[0]['email']; ?>" placeholder="Email" class="form-control" maxlength="100"/>
						</div>
						<?php for($i=0; $i<count($user); $i++) { ?>
						<div class="form-group col-xs-4">
							<label class="control-label" for="dca_firm_name">DCA Firm Name :</label>
							<input type="text" name="dca_firm_name_<?php echo $i;?>" id="dca_firm_name" value="<?php echo $user[$i]['dca_firm_name']; ?>" placeholder="DCA Firm Name" class="form-control" />
						</div>
						<div class="form-group col-xs-4">
							<label class="control-label" for="dca_code">DCA Code :</label>
							<input readonly type="text" name="dca_code_<?php echo $i;?>" id="dca_code" value="<?php echo $user[$i]['dca_code']; ?>" placeholder="DCA Code" class="form-control" maxlength="100"/>
							<input type="hidden" name="dca_id_<?php echo $i;?>" value="<?php echo $user[$i]['dca_id']; ?>" />
						</div>						
						<div class="form-group col-xs-4">
							<label class="control-label" for="dca_ref_code">DCA Reference Code :</label>
							<input readonly type="text" name="dca_ref_code_<?php echo $i;?>" id="dca_ref_code" value="<?php echo $user[$i]['dca_ref_code']; ?>" placeholder="DCA Reference Code" class="form-control" maxlength="100"/>
						</div>
						<?php } ?>
					</div>
					
					<div class="box-header with-border">
						<h3 class="box-title">Update Password</h3>
					</div>
					<div class="box-body">
						<div class="form-group col-xs-4">
							<label class="control-label" for="password">New Password :</label>
							<input type="text" name="password" id="password" value="" placeholder="Password" class="form-control" maxlength="100"/>
						</div>	
						<div class="form-group col-xs-4">
							<label class="control-label" for="confirm_password">Confirm Password :</label>
							<input type="text" name="confirm_password" id="confirm_password" value="" placeholder="Confirm Password" class="form-control" maxlength="100"/>
						</div>
					</div>
					<div class="box-footer">
						<input type="hidden" name="dca_firm_count" value="<?php echo $i; ?>" />
						<input type="button" name="btnSaveChanges" id="btnSaveChanges" class="btn btn-primary pull-right" value="Save" />
					</div>
				</form>
			</div>
		</div>
	</div>
</section>

<script type="text/javascript">

    $('#btnSaveChanges').on('click', function () {
        $('#ajax_response').hide();
        $('#frmAddUser').data('bootstrapValidator').validate();
        var is_valid_frm = $('#frmAddUser').data('bootstrapValidator').isValid();
        if (is_valid_frm) {
			var password = $('#password').val();
			var confirm_password = $('#confirm_password').val();
			var proceed = false;
			if(password == '' && confirm_password == '') {
				proceed = true;
			}else {
				if(password == confirm_password) {
					proceed = true;
				}
			}
			
			if(proceed) {
            var param = $('#frmAddUser').serialize();
            $.ajax({
                method: 'POST',
                url: '<?php echo $base_url; ?>/Profile/save_profile',
                data: param,
                dataType: 'json',
                beforeSend: function () {
                    // $.loading_dialog({text: "Please wait..."});
                },
                success: function (ajax_response) {
                    //$.close_loading_dialog();

                    if (ajax_response.status == 'done') {
                        
						location.href = base_url + "/Profile";
                        
                    } else if (ajax_response.status == 'error') {
                        $('#ajax_response').show();
                        $('#ajax_response').html(ajax_response.message);
                        $("#ajax_response").fadeTo(2000, 500).slideUp(500, function () {
                        });
                    }

                },
                error: function () {
                    $.close_loading_dialog();
                    $.alert_dialog({
                        title: 'Alert',
                        text: "An error has occurred",
                        OkButton: "OK"
                    });
                }
            });
			}else {
				alert('Password and Confirm Password should match!');
			}
        }
    });
    $(document).ready(function () {
		$('#ajax_response_1').show();
		$("#ajax_response_1").fadeTo(5000, 2000).slideUp(2000, function () {
                        });
       
        $('#frmAddUser').bootstrapValidator({
            message: 'This value is not valid',
            feedbackIcons: {
                valid: '',
                invalid: '',
                validating: 'fa fa-refresh'
            },
            fields: {
                
                name: {
                    validators: {
                        notEmpty: {
                            message: 'The Name is required'
                        }
                    }
                },
                email: {
                    validators: {
                        /*notEmpty: {
                            message: 'The User Email is required'
                        },*/
                        emailAddress: {
                           message: 'The input is not a valid email address'
                       }
                    }
                },
                
            }
        }).on('success.field.bv', function (e, data) {
            var $parent = data.element.parents('.form-group');
            $parent.removeClass('has-success');
        });
    });
</script>