<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Login controller will have authentication realted functions
 */
class Login extends CI_Controller {

    public function __construct() {
        parent::__construct();
		header('Access-Control-Allow-Origin: *');
       // use_ssl();
       $this->load->model('User_model');
    }

    /**
     * Idnex function will load login view for user
     * @param null
     * @return login view
     */
    public function index() {
         if ($this->session->userdata('user_id') != '') {
          $base_url = $this->config->item('base_url');
		  $role_id = $this->session->userdata('role');
			if ($role_id == '1' || $role_id == '2') {
                    $redirected_to = 'Dashboard';
                } 
          redirect($redirected_to);
          } 
        $data['msg'] = '';
        $data['is_window'] = false;
        $this->template->load('template/public', "login_view", $data);
    }
	
	
    /**
     * Objective is to to logout from system. Destory session and load logout_view 
     * which will redirect user to login_view.
     * @param null
     * @return load logout_view
     */
    public function logout() {
        $base_url = $this->config->item('base_url');
        if ($this->session->userdata('user_id') == '') {
            redirect($base_url . '/Login');
        }
        $user_id = $this->session->userdata('user_id');
        $this->session->unset_userdata('user_id');
        $this->session->unset_userdata('email');
        $this->session->unset_userdata('name');
        $this->session->unset_userdata('role');
        
        $this->session->sess_destroy();
        $this->load->view('logout_view');
    }
  

    /**
     * Objective is to validate user who used sosical login
     */
    public function social_login_callback() {
		$this->config->load('oneall_settings');
        $this->load->library('Oneall_Curly');
        $this->load->model('User_model', '', TRUE);
        $base_url = $this->config->item('base_url');
        $user_data = array();
       // echo 'I am herere';
       // echo $_POST['connection_token'];
        if (!empty($_POST['connection_token'])) {

            $oneall_site_domain = $this->config->item('oneall_site_domain');
            $connection_token = $_POST['connection_token'];
            $oneall_curly = new oneall_curly();
            $oneall_public_key = $this->config->item('oneall_site_public_key');
            $oneall_private_key = $this->config->item('oneall_site_private_key');
            $oneall_curly->set_option('USERPWD', $oneall_public_key . ':' . $oneall_private_key);
            $oneall_curly->set_option('VERBOSE', 1);
            //echo $oneall_site_domain . "/connections/" . $connection_token . ".json";
            //exit;
            if ($oneall_curly->get($oneall_site_domain . "/connections/" . $connection_token . ".json")) {
                $result = $oneall_curly->get_result();    
                
                $json = $result->body;
                $json_decoded = json_decode($result->body);
                 
                if (strtolower($json_decoded->response->result->status->flag) === 'success') {

                    $data = $json_decoded->response->result->data;
                                        
                    $identity_token = $data->user->identity->identity_token;
                    $identity_provider = $data->user->identity->provider;
                    $user_email = $data->user->identity->emails[0]->value;
                    $username = $user_email;
                    $name = $data->user->identity->displayName;

                    $user_detail = $this->User_model->validate_user($username, '');
                    if (key_exists('user_id', $user_detail) && $user_detail['user_id'] != '') {
                        if ($user_detail['status'] == '1') {
                            $user_data['last_login'] = date('Y-m-d H:i:s', strtotime('now'));
                            $is_updated = $this->User_model->update_user($user_data, $user_detail['user_id']);
                            $this->session->set_userdata('user_id', $user_detail['user_id']);
                            $this->session->set_userdata('email', $user_detail['email']);
                            $this->session->set_userdata('name', $user_detail['name']);
                            $this->session->set_userdata('role', $user_detail['role_id']);
                             $role_id = $user_detail['role_id'];
                            if ($role_id == '1' || $role_id == '2') {
								$redirected_to = 'Dashboard';
							} 
                            redirect($base_url.'/'.$redirected_to);
                            return;
                        }
                        if ($user_detail['status'] != '1') {
                            redirect("$base_url/login?msg=inactive");
                            return;
                        }
                    } else {
                        redirect("$base_url/login?msg=invalid");
                        return;
                    }
                } else {
                    redirect("$base_url/login?msg=invalid");
                    return;
                }
            } else {
                redirect("$base_url/login?msg=invalid");
                return;
            }
        }
    }
    
    
    /**
     * Objective is to authenticate user via ajax call input will be provided in post variables
     * @param string username
     * @param string password
     * @return done if username and password is valid else is_invalid
     */
    public function validate_user() {
        $post = $this->input->post(null, true);
        $username = $post['username'];
        $password = md5($post['password']);
        $this->load->model('User_model');		
		$ajax_response=array('status'=>0,'message'=>'','redirect'=>'');
        $user_detail = $this->User_model->validate_user($username, $password);	
        if (key_exists('user_id', $user_detail) && $user_detail['user_id'] != '') {
            //$this->common->display_data($user_detail);
            if ($user_detail['status'] == '1') {
                $user_data['last_login'] = date('Y-m-d H:i:s', strtotime('now'));
                $is_updated = $this->User_model->update_user($user_data, $user_detail['user_id']);
                $this->session->set_userdata('user_id', $user_detail['user_id']);
                $this->session->set_userdata('email', $user_detail['email']);
                $this->session->set_userdata('name', $user_detail['name']);
                $this->session->set_userdata('role', $user_detail['role_id']);
                $role_id = $user_detail['role_id'];
                if ($role_id == '1' || $role_id == '2') {
                    $redirected_to = 'Dashboard';
                } 
				
                $ajax_response['status']=1;
				$ajax_response['message']='<div class="alert alert-success"><p><span class="fa fa-check-circle fa-fw"></span>Please be patient, you will be redirected in a moment.......</p></div>';
				$ajax_response['redirect']=$redirected_to;   
            }
            if ($user_detail['status'] != '1') {
				$ajax_response['message']='<div class="alert alert-danger"><p><span class="fa fa-exclamation-circle fa-fw"></span>Your account is inactive</p></div>';               
            }
        } else {
			$ajax_response['message']='<div class="alert alert-danger"><p><span class="fa fa-exclamation-circle fa-fw"></span>Your email and password dose not matched</p></div>';     
           
      }
	  echo json_encode($ajax_response);	  
	  
    }
	
	
	

}
